// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 12, Aufgabe 2
// "Umordnen einer Liste"

class Node {
	int val;
	Node next;
	Node(int v, Node n) { val = v; next = n; }
}
	
public class A2 {
	
	// Read a sequence of integers and link them into a list
	static Node readList() {
		In.open("input.txt");
		Node head = null;
		int val = In.readInt();
		while (In.done()) {
			head = new Node(val, head);
			val = In.readInt();
		}
		In.close();
		return head;
	}
	
	// Move all negative elements in front of all positive elements
	static Node reorder(Node list) {
		Node p = list, last = null;
		while (p != null) {
			if (p.val < 0 && last != null) {
				last.next = p.next; p.next = list; list = p;
				p = last.next;
			} else {
				last = p; p = p.next;
			}
		}
		return list;
	}
	
	static void print(Node list) {
		for (Node p = list; p != null; p = p.next) Out.print(p.val + " ");
		Out.println();
	}
	
	public static void main(String args[]) {
		Node list = readList();
		print(list);
		list = reorder(list);
		print(list);
	}
}

/*
Sample input:
6 -27 67 -52 -3 8 98 -3 37 -2 -97 46 2
*/